<?php
header('Content-Type: application/json');
$dbFile = 'ayurkavach_final.sqlite';

try {
    $pdo = new PDO("sqlite:" . $dbFile);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $pdo->exec("CREATE TABLE IF NOT EXISTS orders (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        name TEXT, email TEXT, phone TEXT, address TEXT,
        details TEXT, total REAL, created_at DATETIME DEFAULT CURRENT_TIMESTAMP
    )");

    $input = json_decode(file_get_contents('php://input'), true);

    if ($input) {
        $customer = $input['customer'];
        $items = $input['items'];
        $grandTotal = $input['total'];

        $summary = "";
        foreach ($items as $item) {
            $summary .= "{$item['title']} ({$item['weight']} x{$item['qty']}) - ₹" . ($item['unitPrice'] * $item['qty']) . "\n";
        }

        $stmt = $pdo->prepare("INSERT INTO orders (name, email, phone, address, details, total) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([$customer['name'], $customer['email'], $customer['phone'], $customer['address'], $summary, $grandTotal]);

        // Trigger Email
        //sendConfirmationEmail($customer, $summary, $grandTotal);

        echo json_encode(['status' => 'success']);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}

function sendConfirmationEmail($customer, $summary, $total) {
    $to = $customer['email'];
    $subject = "Order Confirmation - Ayurkavach";
    $message = "Hello " . $customer['name'] . ",\n\nThank you for your order!\n\nDetails:\n" . $summary . "\nTotal: ₹" . $total . "\n\nWe will ship to:\n" . $customer['address'] . "\n\nStay Healthy,\nTeam Ayurkavach";
    $headers = "From: no-reply@ayurkavach.com\r\n" . "X-Mailer: PHP/" . phpversion();

    @mail($to, $subject, $message, $headers); // Send to customer
    @mail("admin@ayurkavach.com", "New Order: " . $customer['name'], $message, $headers); // Send to admin
}
?>